/*
 * Created on 30.03.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package events;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

/**
 * @author aaaliev
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ArrayMatrix implements Matrix {

	int rows;
	int columns;
	double data[][];
	/**
	 * 
	 */
	public ArrayMatrix(int rows, int columns) {
		this.rows = rows;
		this.columns = columns;
		data = new double[rows][columns];
	}

	/**
	 * Load matrix from a file. The file should have following format
	 * 2 3
	 * 1 2 3
	 * 1 2 3
	 * 
	 * The first number specifies number of matrix rows
	 * The second number specifies number of matrix columns
	 * Next columns*rows number is elements of matrix
	 * @param file
	 * @throws IOException
	 */
	public static ArrayMatrix load(String file) throws IOException {
		FileReader is = new FileReader(file);
		StreamTokenizer parser = new StreamTokenizer(is);
		int tok = parser.nextToken();
		if(tok != StreamTokenizer.TT_NUMBER) {
			System.out.println("Unexpeced token:" + tok + " " + parser.sval);
			return null;
		}
		int rows = (int)parser.nval;

		tok = parser.nextToken();
		if(tok != StreamTokenizer.TT_NUMBER) {
			System.out.println("Unexpeced token:" + tok + " " + parser.sval);
			return null;
		}
		int columns = (int)parser.nval;
		ArrayMatrix  matrix = new  ArrayMatrix(rows, columns);
	
		for (int i =0; i < rows; i++)
			for (int j =0; j < columns; j++) {
				tok = parser.nextToken();
				if(tok != StreamTokenizer.TT_NUMBER) {
					System.out.println("Unexpeced token:" + tok + " " + parser.sval);
				}	
				matrix.set(i, j, parser.nval);
			}
		return matrix;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		for (int i =0; i < rows; i++){
			for (int j =0; j < columns; j++) {
				buf.append(get(i, j));
				buf.append(' ');
			}
			buf.append('\n');
		}
		return buf.toString();
	}
	
	/**
	 * @see events.Matrix#rowCount()
	 */
	public int rowCount() {
		return rows;
	}

	/**
	 * @see events.Matrix#columnCount()
	 */
	public int columnCount() {
		return columns;
	}

	/**
	 * @see events.Matrix#get(int, int)
	 */
	public double get(int row, int column) {
		return data[row][column];
	}

	/**
	 * @see events.Matrix#set(int, int, double)
	 */
	public void set(int x, int y, double value) {
		data[x][y] = value;		
	}

	/* (non-Javadoc)
	 * @see events.Matrix#getRow(int)
	 */
	public Vector getRow(int i) {
		return new Row(i);
	}

	/* (non-Javadoc)
	 * @see events.Matrix#getColumn(int)
	 */
	public Vector getColumn(int i) {
		// TODO Auto-generated method stub
		return new Column(i);
	}
	
	public class Row implements Vector {
         int row;
		/**
		 * 
		 */
		public Row(int row) {
			this.row = row;
		}

		/* (non-Javadoc)
		 * @see events.Vector#size()
		 */
		public int size() {
			return ArrayMatrix.this.columns;
		}

		/* (non-Javadoc)
		 * @see events.Vector#get(int)
		 */
		public double get(int i) {
			// TODO Auto-generated method stub
			return ArrayMatrix.this.get(row, i);
		}

		/* (non-Javadoc)
		 * @see events.Vector#set(int, double)
		 */
		public void set(int i, double value) {
			ArrayMatrix.this.set(row, i, value);
		}
	}

	public class Column implements Vector {
        int column;
		/**
		 * 
		 */
		public Column(int column) {
			this.column = column;
		}

		/* (non-Javadoc)
		 * @see events.Vector#size()
		 */
		public int size() {
			return ArrayMatrix.this.rows;
		}

		/* (non-Javadoc)
		 * @see events.Vector#get(int)
		 */
		public double get(int i) {
			// TODO Auto-generated method stub
			return ArrayMatrix.this.get(i, column);
		}

		/* (non-Javadoc)
		 * @see events.Vector#set(int, double)
		 */
		public void set(int i, double value) {
			ArrayMatrix.this.set(i, column, value);
		}
	}
	

}
