/*
 * Created on 29.03.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package events;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author aaaliev
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Dispatcher {
	List generators;
	List handlers;
	Queue messageQueue;

	private static Dispatcher instance = null;
	public static Dispatcher getInstance() {
		if(instance == null) {
			instance = new Dispatcher();
		}
		return instance;
	}
	/**
	 * 
	 */
	private Dispatcher() {
		generators = new ArrayList();
		handlers = new ArrayList();
		messageQueue = new Queue();
		
	}

	public void addHandler(Handler h) {
		handlers.add(h);
	}

	public void addGenerator(Generator g) {
		generators.add(g);
	}

	public void send(Message m) {
		messageQueue.enqueue(m);
	}
	
	public void run(){
		for(;;) {
			if(messageQueue.isEmpty()) {
				for (Iterator iGenerators = generators.iterator(); iGenerators.hasNext();){
					send(((Generator)iGenerators.next()).generate());
				}			
			}
			Message m = (Message) messageQueue.dequeue();
			if(m.getType() == Message.QUIT) {
				break;
			}
			for (Iterator iHandlers = handlers.iterator(); iHandlers.hasNext();){
				((Handler)iHandlers.next()).handle(m);
			}
		}

	}
	
	public static void main(String[] args) {
		Dispatcher d = Dispatcher.getInstance();
		try {
			Matrix a = ArrayMatrix.load("Matrix1.dat");
			Matrix b = ArrayMatrix.load("Matrix2.dat");
			System.out.println("matrix A:\n" + a);
			System.out.println("matrix B:\n" + b);
			
			if(a.columnCount() != b.rowCount()) {
				System.out.println("Incorrect matrix sizes");
				return;
			}
			Matrix res = new ArrayMatrix(a.rowCount(), b.columnCount());
			for(int i =0; i < a.rowCount(); i++) {
				d.addHandler(new VectorMulHandler(a.getRow(i), res.getRow(i), d));
			}
			d.addGenerator(new VectorGenerartor(b, d));
			d.run();
			System.out.println("result matrix:\n" + res);
			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}	

}
